function checkbox($this)
{
	var $checkbox = $('<a class="checkbox"/>');
	
	if($this.attr('checked') === 'checked')
	{
		$checkbox.addClass('checked');
	}
	
	$checkbox.insertBefore($this).click(function()
	{
		if($checkbox.toggleClass('checked').hasClass('checked'))
		{
			$this.attr('checked', 'checked');
		} else
		{
			$this.removeAttr('checked');
		}
	});
	
	$this.removeClass('checkbox').hide();
	
	$.extend($checkbox,
	{
		'check': function()
		{
			$this.attr('checked', 'checked');
			
			$checkbox.addClass('checked');
		},
		'uncheck': function()
		{
			$this.removeAttr('checked');
			
			$checkbox.removeClass('checked');
		}
	});
	
	return $checkbox;
}

$(function()
{
	$('input.file').each(function()
	{
		var $this = $(this).hide(), url = $this.attr('url'), hosting = false;
		
		$this.removeAttr('url');
		
		var $input = $('<input class="text file" type="text" name="url_'+this.name+'" value="'+url+'"/>').insertAfter($this);
		var $browse = $('<a class="file"/a>').insertAfter($this);
		var $host = checkbox($('#host_'+this.name.replace('[', '_').replace(']', '')));
		
		if($this.attr('host') === '1')
		{
			hosting = true;
			
			$host.check();
		}
		
		$host.click(function()
		{
			if(hosting && !$host.hasClass('checked'))
			{
				$host.check();
			}
		});
	
		$this.change(function()
		{
			hosting = true;
			
			$input.val($this.val().replace('C:\\fakepath\\', ''));
			
			$host.check();
		});
		
		$input.change(function()
		{
			if($input.val().substr(0, 7) === 'http://' || $input.val().substr(0, 8) === 'https://')
			{
				hosting = false;
			}
		});
		
		$browse.click(function()
		{
			$this.click();
		});
		
		if(!window.FileReader)
		{
			$this.parent().css('position', 'relative');
			
			$this.show().css(
			{
				'position': 'absolute',
				'left': '165px',
				'width': '36px',
				'height': '36px',
				'opacity': '0',
				'cursor': 'pointer'
			});
			
			$this.hover(function()
			{
				$browse.addClass('hover');
			}, function()
			{
				$browse.removeClass('hover');
			});
		}
	});
	
	$('input.checkbox').each(function()
	{
		checkbox($(this));
	});
});